/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.snmp;

import com.ibm.hwmca.api.SNMPException;
import com.ibm.hwmca.api.SNMPNoSuchNameException;
import com.ibm.hwmca.fw.dpi.DpiConnection;
import com.ibm.hwmca.fw.dpi.DpiHandler;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.FrameworkLogAttributes;
import com.ibm.hwmca.fw.snmp.SnmpErrorIds;
import com.ibm.hwmca.fw.snmp.SnmpHandler;
import com.ibm.hwmca.fw.util.Trace;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class SnmpManager
implements DpiHandler,
SnmpErrorIds {
    private static SnmpManager instance;
    private DpiConnection conn;
    private HashMap handlers;
    private static final String TRACE_MASKD = "XSNMPMRD";
    private static final String TRACE_MASKT = "XSNMPMRT";
    private static final String TRACE_MASKF = "XSNMPMRF";

    private SnmpManager() {
        Trace.trace(TRACE_MASKT, "-> SnmpManager.<init>");
        try {
            this.conn = new DpiConnection(this);
            this.conn.openConnection();
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, e);
            new FrameworkLog(SnmpErrorIds.logInfo, 8192, e).log();
        }
        this.handlers = new HashMap();
        Trace.trace(TRACE_MASKT, "<- SnmpManager.<init>");
    }

    public static synchronized SnmpManager getSnmpManager() {
        if (instance == null) {
            instance = new SnmpManager();
        }
        return instance;
    }

    public void register(String oid, SnmpHandler handler) throws SNMPException {
        Trace.trace(TRACE_MASKT, "-> SnmpManager.register: oid=[" + oid + "].");
        try {
            this.conn.registerSubTree(oid);
            if (oid.charAt(0) == '.') {
                oid = oid.substring(1);
            }
            this.handlers.put(oid, handler);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "Error registering mib subtree");
            Trace.trace(TRACE_MASKD, e);
            throw new SNMPException("Error registering mib subtree", 0);
        }
        Trace.trace(TRACE_MASKT, "<- SnmpManager.register: oid=[" + oid + "].");
    }

    public void unregister(String oid) throws SNMPException {
        Trace.trace(TRACE_MASKT, "-> SnmpManager.unregister: oid=[" + oid + "].");
        try {
            this.conn.unregisterSubTree(oid);
            this.handlers.remove(oid);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "Error unregistering mib subtree");
            Trace.trace(TRACE_MASKF, e);
            throw new SNMPException("Error unregistering mib subtree", 0);
        }
        Trace.trace(TRACE_MASKT, "<- SnmpManager.unregister: oid=[" + oid + "].");
    }

    public Object get(String oid) throws SNMPException {
        Trace.trace(TRACE_MASKT, "-> SnmpManager.get: oid=[" + oid + "].");
        SnmpHandler handler = this.getHandlerForOid(oid);
        if (handler == null) {
            throw new SNMPNoSuchNameException("no handler found");
        }
        Object retVal = handler.get(oid);
        Trace.trace(TRACE_MASKT, "<- SnmpManager.get: oid=[" + oid + "].");
        return retVal;
    }

    public Object[] getNext(String oid) throws SNMPException {
        Trace.trace(TRACE_MASKT, "-> SnmpManager.getNext: oid=[" + oid + "].");
        SnmpHandler handler = this.getHandlerForOid(oid);
        if (handler == null) {
            throw new SNMPNoSuchNameException("no handler found");
        }
        Object[] retVal = handler.getNext(oid);
        Trace.trace(TRACE_MASKT, "<- SnmpManager.getNext: oid=[" + oid + "].");
        return retVal;
    }

    public void set(String oid, Object value) throws SNMPException {
        Trace.trace(TRACE_MASKT, "-> SnmpManager.set: oid=[" + oid + "].");
        SnmpHandler handler = this.getHandlerForOid(oid);
        if (handler == null) {
            throw new SNMPNoSuchNameException("no handler found");
        }
        handler.set(oid, value);
        Trace.trace(TRACE_MASKT, "<- SnmpManager.set: oid=[" + oid + "].");
    }

    public void successfulRegister(String oid) {
        Trace.trace(TRACE_MASKT, "successfuly registered oid " + oid);
    }

    public void failedRegister(String oid) {
        Trace.trace(TRACE_MASKT, "failed to register oid: " + oid);
        new FrameworkLog(SnmpErrorIds.logInfo, 8194, null).log(FrameworkLogAttributes.INFO_LOG);
    }

    private SnmpHandler getHandlerForOid(String oid) {
        SnmpHandler handler = null;
        int matchLen = 0;
        Iterator i = this.handlers.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            String s = (String)entry.getKey();
            if (!oid.startsWith(s) || s.length() <= matchLen) continue;
            handler = (SnmpHandler)entry.getValue();
            matchLen = s.length();
        }
        return handler;
    }
}

